/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import ivorius.ivtoolkit.rendering.IvOpenGLHelper;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Matrix;
import org.lwjgl.util.vector.Matrix2f;
import org.lwjgl.util.vector.Matrix3f;
import org.lwjgl.util.vector.Matrix4f;

public class IvShaderInstance {
    public Logger logger;
    private int shaderID = 0;
    private boolean shaderActive = false;
    private TObjectIntMap<String> uniformLocations = new TObjectIntHashMap();

    public int getShaderID() {
        return this.shaderID;
    }

    public IvShaderInstance(Logger logger) {
        this.logger = logger;
    }

    public void trySettingUpShader(String vertexShaderFile, String fragmentShaderFile) {
        if (this.shaderID <= 0) {
            this.registerShader(vertexShaderFile, fragmentShaderFile);
        }
    }

    public void registerShader(String vertexShaderCode, String fragmentShaderCode) {
        this.deleteShader();
        int vertShader = -1;
        int fragShader = -1;
        try {
            if (vertexShaderCode != null) {
                vertShader = this.createShader(vertexShaderCode, OpenGlHelper.field_153209_q);
            }
            if (fragmentShaderCode != null) {
                fragShader = this.createShader(fragmentShaderCode, OpenGlHelper.field_153210_r);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
        this.shaderID = OpenGlHelper.func_153183_d();
        if (vertShader > 0) {
            OpenGlHelper.func_153178_b((int)this.shaderID, (int)vertShader);
            OpenGlHelper.func_153180_a((int)vertShader);
        }
        if (fragShader > 0) {
            OpenGlHelper.func_153178_b((int)this.shaderID, (int)fragShader);
            OpenGlHelper.func_153180_a((int)fragShader);
        }
        OpenGlHelper.func_153179_f((int)this.shaderID);
        if (OpenGlHelper.func_153175_a((int)this.shaderID, (int)OpenGlHelper.field_153207_o) == 0) {
            this.logger.error(OpenGlHelper.func_153166_e((int)this.shaderID, (int)32768));
        }
        IvOpenGLHelper.glValidateProgram(this.shaderID);
        if (OpenGlHelper.func_153175_a((int)this.shaderID, (int)IvOpenGLHelper.GL_VALIDATE_STATUS) == 0) {
            this.logger.error(OpenGlHelper.func_153166_e((int)this.shaderID, (int)32768));
        }
    }

    private int createShader(String shaderCode, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = OpenGlHelper.func_153195_b((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            byte[] shaderCodeBytes = shaderCode.getBytes();
            ByteBuffer shaderCodeBuf = BufferUtils.createByteBuffer((int)shaderCodeBytes.length);
            shaderCodeBuf.put(shaderCodeBytes);
            shaderCodeBuf.position(0);
            OpenGlHelper.func_153169_a((int)shader, (ByteBuffer)shaderCodeBuf);
            OpenGlHelper.func_153170_c((int)shader);
            if (OpenGlHelper.func_153157_c((int)shader, (int)OpenGlHelper.field_153208_p) == 0) {
                throw new RuntimeException("Error creating shader: " + OpenGlHelper.func_153166_e((int)shader, (int)32768));
            }
            return shader;
        }
        catch (Exception exc) {
            if (shader != 0) {
                OpenGlHelper.func_153180_a((int)shader);
            }
            throw new RuntimeException(exc);
        }
    }

    public boolean useShader() {
        if (this.shaderID <= 0 && !this.shaderActive) {
            return false;
        }
        this.shaderActive = true;
        OpenGlHelper.func_153161_d((int)this.shaderID);
        return true;
    }

    public void stopUsingShader() {
        if (this.shaderID <= 0 && this.shaderActive) {
            return;
        }
        OpenGlHelper.func_153161_d((int)0);
        this.shaderActive = false;
    }

    public boolean isShaderActive() {
        return this.shaderActive;
    }

    public boolean setUniformInts(String key, int ... ints) {
        return this.setUniformIntsOfType(key, ints.length, ints);
    }

    public boolean setUniformIntsOfType(String key, int typeLength, int ... ints) {
        if (this.shaderID <= 0 || !this.shaderActive) {
            return false;
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)ints.length);
        intBuffer.put(ints);
        intBuffer.position(0);
        switch (typeLength) {
            case 1: {
                OpenGlHelper.func_153181_a((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
                break;
            }
            case 2: {
                OpenGlHelper.func_153182_b((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
                break;
            }
            case 3: {
                OpenGlHelper.func_153192_c((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
                break;
            }
            case 4: {
                OpenGlHelper.func_153162_d((int)this.getUniformLocation(key), (IntBuffer)intBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return true;
    }

    public boolean setUniformFloats(String key, float ... floats) {
        return this.setUniformFloatsOfType(key, floats.length, floats);
    }

    public boolean setUniformFloatsOfType(String key, int typeLength, float ... floats) {
        if (this.shaderID <= 0 || !this.shaderActive) {
            return false;
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)floats.length);
        floatBuffer.put(floats);
        floatBuffer.position(0);
        switch (typeLength) {
            case 1: {
                OpenGlHelper.func_153168_a((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
                break;
            }
            case 2: {
                OpenGlHelper.func_153177_b((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
                break;
            }
            case 3: {
                OpenGlHelper.func_153191_c((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
                break;
            }
            case 4: {
                OpenGlHelper.func_153159_d((int)this.getUniformLocation(key), (FloatBuffer)floatBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return true;
    }

    public boolean setUniformMatrix(String key, Matrix matrix) {
        int width;
        if (this.shaderID <= 0 || !this.shaderActive) {
            return false;
        }
        if (matrix instanceof Matrix2f) {
            width = 2;
        } else if (matrix instanceof Matrix3f) {
            width = 3;
        } else if (matrix instanceof Matrix4f) {
            width = 4;
        } else {
            throw new IllegalArgumentException();
        }
        FloatBuffer floatBuffer = BufferUtils.createFloatBuffer((int)(width * width));
        matrix.store(floatBuffer);
        floatBuffer.position(0);
        switch (width) {
            case 2: {
                OpenGlHelper.func_153173_a((int)this.getUniformLocation(key), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            case 3: {
                OpenGlHelper.func_153189_b((int)this.getUniformLocation(key), (boolean)false, (FloatBuffer)floatBuffer);
                break;
            }
            default: {
                OpenGlHelper.func_153160_c((int)this.getUniformLocation(key), (boolean)false, (FloatBuffer)floatBuffer);
            }
        }
        return true;
    }

    public Integer getUniformLocation(String key) {
        if (this.shaderID <= 0) {
            return 0;
        }
        if (!this.uniformLocations.containsKey((Object)key)) {
            this.uniformLocations.put((Object)key, OpenGlHelper.func_153194_a((int)this.shaderID, (CharSequence)key));
        }
        return this.uniformLocations.get((Object)key);
    }

    public void deleteShader() {
        if (this.shaderActive) {
            this.stopUsingShader();
        }
        if (this.shaderID > 0) {
            OpenGlHelper.func_153187_e((int)this.shaderID);
            this.shaderID = 0;
        }
        this.uniformLocations.clear();
    }

    public static void outputShaderInfo(Logger logger) {
        String majorVersion;
        String minorVersion;
        String glslVersion;
        String renderer = GL11.glGetString((int)7937);
        String vendor = GL11.glGetString((int)7936);
        String version = GL11.glGetString((int)7938);
        boolean fboSupported = OpenGlHelper.field_148823_f;
        try {
            glslVersion = GL11.glGetString((int)35724);
        }
        catch (Exception ex) {
            glslVersion = "? (No GL20)";
        }
        try {
            minorVersion = "" + GL11.glGetInteger((int)33308);
            majorVersion = "" + GL11.glGetInteger((int)33307);
        }
        catch (Exception ex) {
            minorVersion = "?";
            majorVersion = "? (No GL 30)";
        }
        IvShaderInstance.printAlignedInfo("Vendor", vendor, logger);
        IvShaderInstance.printAlignedInfo("Renderer", renderer, logger);
        IvShaderInstance.printAlignedInfo("Version", version, logger);
        IvShaderInstance.printAlignedInfo("Versions", IvShaderInstance.getGLVersions(GLContext.getCapabilities()), logger);
        IvShaderInstance.printAlignedInfo("Version Range", String.format("%s - %s", minorVersion, majorVersion), logger);
        IvShaderInstance.printAlignedInfo("GLSL Version", glslVersion, logger);
        IvShaderInstance.printAlignedInfo("Frame buffer object", fboSupported ? "Supported" : "Unsupported", logger);
    }

    private static void printAlignedInfo(String category, String info, Logger logger) {
        logger.info(String.format("%-20s: %s", category, info));
    }

    private static String getGLVersions(ContextCapabilities cap) {
        String versions = "";
        try {
            if (cap.OpenGL11) {
                versions = versions + ":11";
            }
            if (cap.OpenGL12) {
                versions = versions + ":12";
            }
            if (cap.OpenGL13) {
                versions = versions + ":13";
            }
            if (cap.OpenGL14) {
                versions = versions + ":14";
            }
            if (cap.OpenGL15) {
                versions = versions + ":15";
            }
        }
        catch (Throwable throwable) {
            versions = versions + ":lwjgl-Error-1";
        }
        try {
            if (cap.OpenGL20) {
                versions = versions + ":20";
            }
            if (cap.OpenGL21) {
                versions = versions + ":21";
            }
        }
        catch (Throwable throwable) {
            versions = versions + ":lwjgl-Error-2";
        }
        try {
            if (cap.OpenGL30) {
                versions = versions + ":30";
            }
            if (cap.OpenGL31) {
                versions = versions + ":31";
            }
            if (cap.OpenGL32) {
                versions = versions + ":32";
            }
            if (cap.OpenGL33) {
                versions = versions + ":33";
            }
        }
        catch (Throwable throwable) {
            versions = versions + ":lwjgl-Error-3";
        }
        if (versions.length() > 0) {
            versions = versions.substring(1);
        }
        return versions;
    }
}

